package java.game.cars;

import java.util.*;
import java.util.resource.*;
import java.game.parts.bodypart.*;


public class Furrano_FL_door extends FrontDoor
{
	public Furrano_FL_door( int id )
	{
		super( id );
		carCategory = PACKAGE;
		name = "Furrano front left door";

		value = 1340;
	}
	
	public void addStockParts( int actcolor, float optical, float power )
	{
		super.addStockParts( actcolor, optical, power );

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_04.furrano:0x000000B7r, "FL window", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_04.furrano:0x000000B7r, "FL window", actcolor, optical, power );
		}

		// parts that have multiple appearance //
		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_04.furrano:0x000001BAr, "L mirror", actcolor, optical, power );
		} else
		{
			float part_random = random();
			if ( part_random >= 0.66667 ) addPart( cars.cat_04.furrano:0x000003BAr, "L mirror 3", actcolor, optical, power ); else
			if ( part_random >= 0.33333 ) addPart( cars.cat_04.furrano:0x000000BAr, "L mirror 2", actcolor, optical, power ); else
			addPart( cars.cat_04.furrano:0x000001BAr, "L mirror", actcolor, optical, power );
		}
	}
}
